//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
    using System;

	/// <summary>
	/// Represents a container of cash sales.
	/// </summary>
	/// <TgData>
	/// </TgData>
    public interface ICashSaleContainer : IDataContainer
    {
		/// <summary>
		/// Gets the sale at the specified index.
		/// </summary>
		/// <param name="index"> The sale index </param>
		ICashSale getCashSaleAt( int index );

		/// <summary>
		/// Adds new cash sale.
		/// </summary>
		/// <param name="newCashSale"> The cash sale </param>
		void addCashSale( ICashSale newCashSale );

		/// <summary>
		/// Removes the cash sale.
		/// </summary>
		/// <param name="objCashSale"> The cash sale </param>
		bool removeCashSale( ICashSale objCashSale );

		/// <summary>
		/// Returns the subtotal amount.
		/// </summary>
		Decimal getSubTotal();

		/// <summary>
		/// Returns the tax amount.
		/// </summary>
		Decimal getTax();

		/// <summary>
		/// Returns the total amount.
		/// </summary>
		Decimal getTotal();
    }
}
